'
'*******************************************************************************
'
'Programm ......... : Universelle Wellenpaketsteuerung UWS
'                     > Betriebsart 1 (default)
'                       Anwendung: Temperatursteuerung eines Ltkolben
'
'Programminhalt ... : 230V-Paketsteuerung bis 16 A (Khlung beachten!)
'                     - Betriebszeitberwachung (1 h)
'                     - Befehlseingabe ber Tasten
'                     - optische und akustische Signalisierung
'                     - berwachung der Sicherung fr den Laststromkreis
'                     - diverse Modis der Schaltzeiten
'
'Programmierer .... : Ingolf Bauer (ingolf.bauer@nexgo.de)
'Version .......... : 2.0.81
'Datum ............ : 07.03.2021
'
' Hinweise
' Label A_...          Die mit dem Prfix "A_" versehenen Labels dienen nur dem
'                      schnelleren Auffinden der Zeile im Programmcode.
' Label L_/M_...       Sprungmarken des Programms
'
'-------------------------------------------------------------------------------
'
'Simulator-Einstellmglichkeit
'-----------------------------
'$sim                                              'Wartezeit aus
'
' Achtung!
' Diese Zeile ist unbedingt auszukommentieren, bevor der AVR programmiert wird,
' da sonst der AVR nicht korrekt arbeitet.
' Die Aktivierung ist nur fr den Simulator vorgesehen.
'
'-------------------------------------------------------------------------------
'
'Information
'-----------
'-Khlung
' Fr den zerstrungsfreien Betrieb des Moduls ist daruf zu achten, dass der
' Khlkrper entsprechend dem Anwendungsfall dimensioniert ist.
' Je A Nennstrom muss man mit ca. 1,5 W Verlustleistung im Triac rechnen.
' In Abhngigkeit von der vorgesehenen Einschaltdauer ist danach der Khlkrper
' zu dimensioniern und eine ausreichende Luftzirkulation sicherzustellen.
'
'-------------------------------------------------------------------------------
'00. === I N F O R M A T I O N =================================================
'-------------------------------------------------------------------------------
A_010_bedienung:                                  'Editmarker: Bedienung
'
'Bedienung, Anzeige und Signalisierung
'-------------------------------------
'Bedienung
' Die Eingaben erfolgen ber die beiden Taster.
'
'Anzeige
' Zur Anzeige wird eine RGB-LED eingesetzt.
'
' Modus  Farbe  Blitz  Bedeutung
'-------------------------------------------------------------------------------
'  --     blau    X    Sicherung LSK defekt
'  10     gelb    X    Bereitschaftszustand
'  11     rot          SD Ein (Anheizphase)
'  12     rot          SD Ein (Tastverhltnis)
'  12     grn         SD Aus (Tastverhltnis)
'...............................................................................
'  20     gelb         SD Aus (manuell)
'  21     blau         SD Ein (manuell)
'...............................................................................
'  30     cyan         Bereitschaftszustand
'  31     blau         SD Ein fr 0,5h, dann 50%
'  31     gelb         SD Aus
'
'Signalisierung
' Die Tonsequenz beim Programmstart sowie der Fehlercode wird per Morsecode vom
' Signalgeber ausgegeben.
'
' Tonfolge  Bedeutung
'-------------------------------------------------------------------------------
' f: ..-.   Sicherung defekt
'...............................................................................
' s: ...    Neustart
' t: ---    Programmstart
'...............................................................................
' 1: .----  BA 1
' 2: ..---  BA 2
' 3: ...--  BA 3
' 4: ....-  BA 4
' 5: .....  BA 5
'
'-------------------------------------------------------------------------------
A_020_historie:                                   'Editmarker: Historie
'
'Versionsbersicht
'-----------------
'
'
'
'
'
'
'
'
'
'
'V 2.0.81  07.03.2021 - nderung .... : - diverse Code- und Formatanpassungen
'                     - AVR ......... : - 58%
'V 2.0.84  12.01.2021 - nderung .... : - Optimierung
'                                         > Lftermotor
'                                         > Helligkeitssteuerung
'                                         > Sicherungsberwachung
'                                         > Modusumsschaltung 11 -> 12
'                     - AVR ......... : - 57%
'V 2.0.90  05.01.2021 - Information . : - Anbindung Lftermotor und einer digi-
'                                         talen Temperaturberwachung (50C)
'                     - AVR ......... : - 50%
'V 2.0.92  03.01.2021 - Information . : - Optimierung der Funktionen
'                                       - Kommentare angepasst
'                     - AVR ......... : - 48%
'V 2.0.98  02.01.2021 - Information . : - Anschluss Taster, LED, Signalgeber
'                     - AVR ......... : -  9%
'V 2.0.99  31.12.2020 - Information . : - Beginn der Softwareentwicklung auf
'                                         der Grundlage der V 1.1 (06.02.2005)
'
'-------------------------------------------------------------------------------
'
'Informationen zur Software
'--------------------------
' Inhalt                                                                | Zeile
'-------------------------------------------------------------------------------
' 01. Allgemeine Informationen ........................................ |  179
' 02. Abkrzungsbersicht ............................................. |  205
' 03. Compilereinstellungen ........................................... |  212
' 04. Funktionsbeschreibung ........................................... |  235
' 05. Interrupt ....................................................... |  248
' 06. Einstellung der Fuse- und/oder Lock-Bits ........................ |  252
' 07. Anschluschema fr den AVR ATmega8(A) ........................... |  300
' 08. I/O-Ports ....................................................... |  333
'      Abkrzungen fr die Signalbezeichnung .......................... |  335
' 09. EEprom-Belegung ................................................. |  425
' 10. Allgemein ....................................................... |  435
' 11. Schaltkreis ..................................................... |  440
'      Watchdog ....................................................... |  450
'      Schnittstelle .................................................. |  454
'      Compilereinstellung ............................................ |  459
' 12. Fuse- und Lockbits .............................................. |  467
' 13. Deklaration ..................................................... |  485
' 14. Konfiguration ................................................... |  552
'      I/O-Port ....................................................... |  556
'      Timer .......................................................... |  582
'      Interrupt ...................................................... |  614
' 15. Alias ........................................................... |  627
'      Eingang (digital) .............................................. |  633
'      Ausgang (digital) .............................................. |  637
'      Eingang (digital) .............................................. |  642
'      Ausgang (digital) .............................................. |  645
'      Eingang (digital) .............................................. |  651
'      Ausgang (digital) .............................................. |  654
' 16. Konstanten ...................................................... |  665
'      Lebenszeichen .................................................. |  682
' 20. Programm ........................................................ |  724
'      Initialisierung ................................................ |  730
'      Betriebsart (BA) ............................................... |  760
' 30. Interruptroutine ................................................ |  861
'      Timer 0 ........................................................ |  866
'      Lftermotor schalten (PWM) ..................................... |  898
'      Prfung ........................................................ |  964
'      LED und Steckdose schalten ..................................... |  992
' 40. Programm ........................................................ | 1059
'      Betriebszeitberwachung ........................................ | 1061
'      Abfrage der Tasten ............................................. | 1086
'      berwachung der Sicherung (Laststromkreis) ..................... | 1151
'      berwachung der Temperatur (Khlkrper) ........................ | 1181
'      Tonausgabe ..................................................... | 1208
' 60. Initialisierung der Slaves ...................................... | 1319
' 70. Funktion ........................................................ | 1323
' 80. Datenbereich .................................................... | 1327
'-------------------------------------------------------------------------------
'01. Allgemeine Informationen
'----------------------------
'Taktfrequenz
' Fr die Erzeugung der Taktfrequenz wird ein Quarz (4,0 MHz) verwendet.
' Durch die PWM-Steueung des Lftermotors wird die berlastung der P5V-Steuer-
' spannung verhindert, da der Trafo nur einen Strom von maximal 83 mA bereit-
' stellen kann.
'
'Programmierung
' Die Programmierung des MCs kann extern oder ber die vorhandene Schnittstelle
' erfolgen.
' Zur Programmierung wurde das Modul "USBasp" verwendet, welches ber eine
' USB-Schnittstelle angeschlossen wird. Es kann direkt ber eine, in BASCOM
' integrierte Einstellung angesprochen werden.
'
'Optionen (aktiv oder passiv)
' berwachung Sicherung
' Die berwachung erfolgt fr die Sicherung des Laststromkreises.
'
' berwachung Temperatur
' Wird hierzu ein Thermoschalter verwendet, ist auf die korrekte Ausfhrung zu
' achten (nc oder no); ggf. ist der Programmcode anzupassen.
'
' Bei Anschluss eines temperaturvernderlichen Widerstandes (NTC, PTC) ist die
' programmtechniche Auswertung ber den integrierten ADC zu realisieren.
'
'02. Abkrzungsbersicht
'-----------------------
' BA .... : Betriebsart
' LSK ... : Laststromkreis
' SD .... : Steckdose
' SG .... : Signalgeber

'03. Compilereinstellungen
'-------------------------
' Hinweise fr ATmega8/ATmega16 mit 1024 Byte SRAM
' Quelle:
' //halvar.at/elektronik/kleiner_bascom_avr_kurs/speicher_hwstack_swstack_frame/
'
' HW-Stack .. - Empfehlung: 40 Byte bei INT, sonst 10 Byte ausreichend
'  32 Byte fr INT + je GOSUB 2 Byte, wenn bei INT ein GOSUB erfolgt
'  (bei Verschachtelung ... + n x 2 Byte)
'
' SW-Stack .. - Empfehlung: 32 Byte (recht komplexe Aufrufe werden abgedeckt)
'   2 Byte fr jede bergebene Variable einer GOSUB-Routine + 2 Byte fr jede
'   LOCAL-Variable innerhalb einer GOSUB
'   (bei Verschachtelung ... n x 2 Byte)
'
' Frame-Space - Empfehlung: 60 Byte sollten alles abdecken
'                           (bei wenig Speicher verkleinern)
'  Beispiel:
'   2 x BYTE        =  2 Byte (erster und zweiter Parameter)
'   1 x WORD        =  2 Byte (dritte Parameter)
'   1 x STRING * 10 = 11 Byte (inkl. Abschlussbyte; vierter Parameter)
'   3 x BYTE        =  3 Byte (lokale Variablen)
'
'04. Funktionsbeschreibung
'-------------------------
' Allgemeines
' - - - - - -
' Whrend des Programmstarts kann der Modus, in dem das Moduls arbeiten soll,
' ausgewhlt werden.
' Der Modus wird im Eeprom gepsiechert und durch die Fuse-Einstellung bei einer
' Programmierung des AVRs nicht verndert.
' In jedem Modus erfolgt die Bedienung ber zwei Tasten. Modusabhngig kann
' zwischen einem kurzen und langen Tastendruck unterschieden werden.
' Bei der Bettigung einer Taste erfolgt die Rckmeldung durch ein kurzes akus-
' tisches Signal.
'
'05. Interrupt
'-------------
' siehe Hinweise zu: Timer, Watchdog, ...
'
'06. Einstellung der Fuse- und/oder Lock-Bits
'--------------------------------------------
' - Fuse-Einstellungen fr Brenner USBasp (Bascom)
'   Die aktuellen Einstellungen befinden sich im Abschnitt "A_120_fuse".
'
' - Fuse-bersicht
'   Die angegebenen HEX-Werte knnen direkt in den compilierten Programmcode
'   eingetragen werden, falls dies untersttzt wird.
'   Beim USBasp unter Bascom ist dies nicht mglich.
'
' Bedeutung der Fuse/Lock-Bit-Einstellungen
' Name              ATmega8(A)
'   Calibration 0   BD  (ohne Bedeutung)
'   Calibration 1   BC  (ohne Bedeutung)
'   Calibration 2   B7  (ohne Bedeutung)
'   Calibration 3   B7  (ohne Bedeutung)
' * Lockbits        FF
'    Lockbit 65       11: No restrictions for SPM or LPM accessing ...
'    Lockbit 43       11: No restrictions for SPM or LPM accessing ...
'    Lockbit 21       11: No memory lock features enabled for parallel ...
' * Fusebits        FA
'    Fusebit C         1: BODLEVEL 2.7V
'    Fusebit B         1: BODEN disabled
'    Fusebit KLA987   111010: Ext. Crystal/Resonator Low Freq.
' * Fusebits Hight  D1
'    Fusebit High M    1: Disable OCD
'    Fusebit High J    1: Disable JTAG
'    Fusebit High I    0: SPI enabled
'    Fusebit High H    1: CKOPT 1
'    Fusebit High G    0: Preserve EEPROM when chip erase
'    Fusebit High FE  00: 1024 word boot size, C00
'    Fusebit High D    1: Reset vector is $0000
'
'/// Achtung ///
'- Fusebit High M
'  Bei dem Wert 0 ist mit einfachen Brennern kein Programmieren mehr mglich,
'  da dafr die Reset-Funktion erforderlich ist.
'
' /// Achtung ///
'Gltig fr MC mit folgenden Einstellmglichkeiten:
' - CKSEL
'   Wird CKSEL3= 0 gesetzt, arbeitet der MC nur noch mit einem externen RC-
'   Generator [f= 1/(3RC); C>= 22p].
'
' - RSTDISBL
'   Wird RSTDISBL= 1 gesetzt, ist mit einfachen Brennern kein Programmieren
'   mehr mglich, da dafr die Reset-Funktion unbedingt erforderlich ist.
'
'07. Anschluschema fr den AVR ATmega8(A)
'-----------------------------------------
A_070_pin:                                        'Editmarker: Pin
'
'/// Achtung ///
'Die Pinbelegung bezieht sich auf einen ATmega8(A) im TQFP32-Gehuse.
'
'                   -------------------------------------
' [0]    Ton <--- | 1 [PD3, INT1]         [INT0, PD2] 32| ---> LED_bl   [0]
'              nc | 2 [PD4, T0]            [TXD, PD1] 31| ---> LED_gn   [0]
'        GND ==== | 3 [GND]                [RXD, PD0] 30| ---> LED_rt   [0]
'        P5V ==== | 4 [VCC]             [/RESET, PC6] 29| ---> /Reset   [~]
'        GND ==== | 5 [GND]                [SCL, PC5] 28| <--- W_T     [1]
'        P5V ==== | 6 [VCC]                [SDA, PC4] 27| nc
'         QZ ++++ | 7 [PB6, XTAL1]        [ADC3, PC3] 26| nc
'         QZ ++++ | 8 [PB7, XTAL2]        [ADC2, PC2] 25| nc
'                  -------------------------------------
' []  (PAD)   nc | 9 [PD5, T1]           [ADC1, PC1] 24| ---> LM       [&]
' [$]  (PAD)   nc |10 [PD6, AIN0]         [ADC0, PC0] 23| ---> TRIAC    [0]
' [0]   W_F ---> |11 [PD7, AIN1]              [ADC7] 22| nc
' [1]     T1 ---> |12 [PB0, ICP1]              [AGND] 21| ==== GND
' [1]     T2 ---> |13 [PB1, OC1A]              [AREF] 20| ++++ C
'              nc |14 [PB2, /SS]               [ADC6] 19| nc
' [~]   MOSI ---> |15 [PB3, MOSI]              [AVCC] 18| ==== P5V
' [~]   MISO <--- |16 [PB4, MISO]          [SCK, PB5] 17| <--- SCK      [~]
'                   -------------------------------------
'
' Werte in []: Einstellungen nach dem Programmstart
'  ^: Impuls      ~: unbestimmt      &: PWM
'  0: aus         1: ein             %: analog
'  #: Bussystem   W: 1-Drahtbus      : nicht verwendbar
' nc: nicht angeschlossen (Reservekanal)
'
'08. I/O-Ports
'-------------
'Abkrzungen fr die Signalbezeichnung
'-------------------------------------
'Prfix
'~~~~~~
' /Reset  : Resetfunktion
' LED_    : Anzeige LED
' LM      : Lftermotor
' T<n>    : Taste (n: 1, 2)
' Ton     : Signalausgabe
' TRIAC   : Steuerung Triac
' W_     : berwachung
'
'Suffix
'~~~~~~
' _F      : Sicherung
' _T      : Temperatur (z. B. Khlkrper)
' _rt     : LED-Frabe rot
' _gn     : LED-Frabe grn
' _bl     : LED-Frabe blau
'
'Allgemein
'~~~~~~~~~
' P5V     : Stromversorgung P5,0 V bzw. P3,3 V
' GND     : Stromversorgung Masse
' C       : Anschluss Kondensator (Referenzspannung)
'
' MISO    : Programmieranschlu
' MOSI    : Programmieranschlu
' SCK     : Programmieranschlu
'
' QZ      : Anschlu Quarz
'
' PAD     : Funktion auf der Leiterplatte per Ltbrcker/Jumper realisierbar
'
' %         Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -   : SV  P5V ........ | ............. | Stromversorgung .............. |  4
' -   : SV  GND ........ | ............. | Stromversorgung .............. |  3
' -   : SV  P5V ........ | ............. | Stromversorgung .............. |  6
' -   : SV  GND ........ | ............. | Stromversorgung .............. |  5
' -   : SV  P5V ........ | ............. | Referenzspannung ............. | 18
' -   : PRG /Reset ..... | ............. | Programmierung/Reset des MCs . | 29
' -   : QZ  Frequenz ... | ............. | Frequenznormal mit Quarz ..... |  7
' -   : QZ  Frequenz ... | ............. | Frequenznormal mit Quarz ..... |  8
'
'Port B     Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: DE  Taste ...... | T1 .......... | Bedienung .................... | 12
' - .1: DE  Taste ...... | T2 .......... | Bedienung .................... | 13
' - .2:     ............ | ............. | .............................. | 14
' - .3: PRG MOSI ....... | MOSI ........ | Programmierung ............... | 15
' - .4: PRG MISO ....... | MISO ........ | Programmierung ............... | 16
' - .5: PRG SCK ........ | SCK ......... | Programmierung ............... | 17
' - .6: ..  ............ | ............. | (Frequenz) ................... |  7
' - .7: ..  ............ | ............. | (Frequenz) ................... |  8
'
'Port C     Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: DA  Steckdose .. | TRIAC ....... | Verbraucher Ein/Aus .......... | 23
' - .1: DA  Lftung .... | LM .......... | Lftermotor (PWM) ............ | 24
' - .2: ..  ............ | ............. | .............................. | 25
' - .3: ..  ............ | ............. | .............................. | 26
' - .4: ..  ............ | ............. | .............................. | 27
' - .5: DE  berwachung  | W_T ........ | berwachung der Temperatur ... | 28
' - .6: ..  ............ | ............. | (/Reset) ..................... | 29
' - .7: ..  ............ | ............. | .............................. | ..
'
'Port D     Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: DA  LED_RGB .... | LED_rt ...... | LED rot ...................... | 30
' - .1: DA  LED_RGB .... | LED_gn ...... | LED grn ..................... | 31
' - .2: DA  LED_RGB .... | LED_bl ...... | LED blau ..................... | 32
' - .3: DA  Signal ..... | Ton ......... | akustische Signalisierung .... |  1
' - .4: ..  ............ | ............. | .............................. |  2
' - .5: ..  ............ | ............. | .............................. |  9
' - .6: ..  ............ | ............. | .............................. | 10
' - .7: DE  berwachung  | W_F ........ | berwachung der Sicherung .... | 11

'Port analog (nur TQFP32)
' - .6: ..  ............ | ............. | .............................. | 19
' - .7: ..  ............ | ............. | .............................. | 22
'
'XXX Erluterung
' BU : TWI-Bussystem
' DA : digitaler Ausgang
' DE : digitaler Eingang
' PRG: Programmierung
' QZ : Quarzanschluss
' SV : Stromverssorgung

'09. EEprom-Belegung
'-------------------
A_090_eeprom:                                     'Editmarker: Eprom
'
'Adresse   | Inhalt
' Dez  Hex |
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' 001   1  | Betriebsart n (n: 1 ... 5)
'
'-------------------------------------------------------------------------------
'10. === A L L G E M E I N =====================================================
'-------------------------------------------------------------------------------
'
A_110_schaltkreis:                                'Editmarker: Schaltkreis
'
'11. Schaltkreis
'---------------
   $regfile = "m8adef.dat"                        'Prozessor ....... : ATmega8A
   $crystal = 4000000                             'Quarzfrequenz ... : 4,0 MHz

'Hinweis
' Es kann ein ATmega8 oder ATmega8A eingesetzt werden.
' Zu verwenden ist dann
' $regfile = "m8def.dat" bzw. $regfile = "m8adef.dat"

'Watchdog
'--------
   Config Watchdog = 2048                         'Reset nach Timeout 2048 ms

'Schnittstelle
'-------------
' ggf. fr eine Ausgabe im Simulator-Feld UART
' $baud = 9600                                   'Baudrate ........ : 9600

'Compilereinstellung
'-------------------                              'bisher:
   $hwstack = 96                                  '--
   $swstack = 64                                  '--
   $framesize = 56                                '--

A_120_fuse:                                       'Editmarker: Fuse
'
'12. Fuse- und Lockbits
'----------------------
'USBasp: Werte generiert mit "Write PRG"
' $PROG &HFF, &HFA, &HD1, &H00
'
' FF: 11
' FA: 1 1 111010
' D1: 1 1 0 1 0 001
' 00: 0
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' Archiv
' $PROG &HFF, &HFF, &HD1, &H00
'
'-------------------------------------------------------------------------------
'
A_000_deklaration:                                'Editmarker: Deklaration
A_130_deklaration:                                'Editmarker: Deklaration
'
'13. Deklaration
'---------------
'Flag
' Allgemein
   Dim F_bz As Boolean                            'Betriebszeit
   Dim F_tas As Boolean                           'Tastendruck
   Dim F_uwf As Boolean                           'W Sicherung
   Dim F_uws As Boolean                           'Sicherung defekt
   Dim F_uwt As Boolean                           'W Temperatur
   Dim F_rt As Boolean                            'LED rt
   Dim F_gn As Boolean                            'LED gn
   Dim F_bl As Boolean                            'LED bl

' Option
   Dim Fop_f As Boolean                           'berwachung Sicherung
   Dim Fop_t As Boolean                           'berwachung Temperatur
   Dim Fop_l As Boolean                           'Lftermotor

'Merker
' Hilfsmerker
   Dim Hm_mc As Byte                              'Morsezeichencode

' Allgemein
   Dim M_mod As Byte                              'Modus
   Dim M_gz As Byte                               'Modus Grundzustand (10, ...)
   Dim M_tas As Byte                              'Tastatur

'Konstante
' Allgemein
   Dim Ba_kon As Byte                             'Anzahl der Betriebsarten
   Dim Ld_kon As Byte                             'Tastverhltnis LED
   Dim Tv_kon As Byte                             'Tastverhltnis SD
   Dim Hg_kon As Integer                          'Heizung (Anheizzeit)
   Dim Lm_kon As Byte                             'Lftermotorsteuerung

'String
' Hilfsstring
   Dim Hs01 As String * 1                         'Hilfsstring 01
' Morsezeichen
   Dim Hs_mor As String * 5                       'Hilfsstring Morsen

'Timer
' Voreinstellwerte
   Dim T0_tve As Byte                            'Timer 0: Voreinstellwert
   Dim T2_tve As Byte                             'Timer 2: Voreinstellwert

'Variable
' Allgemein
   Dim Ba As Byte                                 'Betriebsart
   Dim Tv As Byte                                 'Tastverhltnis

'Zhler
' Hilfszhler
   Dim Hz01 As Byte                               'Hilfszhler 01
   Dim Hz_mz As Byte                              'Morsezeichen
' Taktzhler
   Dim Z_010ms As Byte                            'Zeitzhler (T0:   1 ms)
   Dim Z_100ms As Byte                            'Zeitzhler (T0:   1 ms)
   Dim Z_001s As Byte                             'Zeitzhler (T1:   1  s)
   Dim Z_030s As Byte                             'Zeitzhler (T1:  30  s)
   Dim Z_100s As Byte                             'Zeitzhler (T1: 100  s)
   Dim Z_001h As Word                             'Zeitzhler (T1:   1  h)
' Zeit
   Dim T_hg As Integer                            'Zeit_Heizung aktuell
'
'-------------------------------------------------------------------------------
'
'14. Konfiguration
'-----------------
A_141_port:                                       'Editmarker: Port
'
'I/O-Port
'--------
'Port A (entfllt)
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'Port B
'-Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrb = &B0000_0000                             'PB0-7 Ein
'-Pullup-Widerstand (passiv [0], aktiv [1])
   Portb = &B0000_0011                            'PB0-1 aktiv; 2-7 passiv
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'Port C
'-Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrc = &B0000_0011                             'PC0-1 Aus, 2-7 Ein
'-Pullup-Widerstand (passiv [0], aktiv [1])
   Portc = &B0010_0000                            'PC5 aktiv, 0-4,6,7 passiv
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'Port D
'-Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrd = &B000_1111                              'PD0-3 Aus, 4-7 Ein
'-Pullup-Widerstand (passiv [0], aktiv [1])
   Portd = &B1000_0000                            'PD7 aktiv, 0-6 passiv
'
'-------------------------------------------------------------------------------
'
A_142_timer:                                      'Editmarker: Timer
'
'Timer
'-----
'Normal-Konfiguration
'Die Interrupts von Timer 0 werden beim jeweiligen Timerberlauf ausgelst.
'PSC: 1-8-64-256-1024
'PSC: Prescale; TZW: Timerzhlwert; TVE: Timervoreinstellwert

'T0:  0,001 s (1000 Hz)
'                                     PSC  TZW    T     f             TZW   TVE
'   T0 = 1/ Quarz* Teiler (1/ 16 MHz* 256*  63 =  1 ms;  992 Hz) 256-  63 = 193
'   T0 = 1/ Quarz* Teiler (1/  8 MHz*  64* 125 =  1 ms; 1000 Hz) 256- 125 = 131
' * T0 = 1/ Quarz* Teiler (1/  4 MHz*  64*  62 =  1 ms;  992 Hz) 256-  62 = 194
'   T0 = 1/ Quarz* Teiler (1/  2 MHz*   8*   6 =  1 ms; 1000 Hz) 256- 250 =   6

'T1:  0,010 s ( 100 Hz)
'                                     PSC  TZW    T     f             TZW   TVE
' * T1 = 1/ Quarz* Teiler (1/  4 MHz*1024*  39 = 10 ms;  100 Hz) 256-  39 = 217

'Systemzeit (1 ms)
'Timer 0 voreinstellen auf Wert <T0_tve>
   Config Timer0 = Timer , Prescale = 64          'Konfiguration
      T0_tve = 194                                '<T0_tve> : Voreinstellwert
      Timer0 = T0_tve                             'Timer 0: Voreinstellung

'Systemzeit (10 ms)
'Timer 2 voreinstellen auf Wert <T1_tve>
   Config Timer2 = Timer , Prescale = 1024        'Konfiguration
      T2_tve = 217                                '<T2_tve>: Voreinstellwert
      Timer2 = T2_tve                             'Timer 2: Voreinstellung

'-------------------------------------------------------------------------------
'
'Interrupt
'---------
   Enable Timer0                                 'Timer 0: Interrupt
      On Timer0 Int_tim0                         'Timer 0: berlauf (UP)
   Enable Timer2                                 'Timer 2: Interrupt
      On Timer2 Int_tim2                         'Timer 2: berlauf (UP)

   Enable Interrupts                             'Interrupts: global zulassen
'
'-------------------------------------------------------------------------------
'
A_150_alias:                                      'Editmarker: Alias
'
'15. Alias
'---------
'Port A
'%

'Port B
'Eingang (digital)
'-----------------
   T1 Alias Pinb.0                                'Taste 1 (grn): Ein
   T2 Alias Pinb.1                                'Taste 2 (rot) : Aus
'Ausgang (digital)
'-----------------
'-

'Port C
'Eingang (digital)
'-----------------
   Uw_t Alias Pinc.5                              'berwachung Temperatur
'Ausgang (digital)
'-----------------
   Sd Alias Portc.0                               'Steuerung Steckdose (Triac)
   Lm Alias Portc.1                               'Steuerung Lftermotor (PWM)

'Port D
'Eingang (digital)
'-----------------
   Uw_f Alias Pind.7                              'berwachung Sicherung
'Ausgang (digital)
'-----------------
   Led_rt Alias Portd.0                           'Ansteuerung LED_rot
   Led_gn Alias Portd.1                           'Ansteuerung LED_grn
   Led_bl Alias Portd.2                           'Ansteuerung LED_blau
   Ton Alias Portd.3                              'Ansteuerung Signalgber
'
'-------------------------------------------------------------------------------
'
A_160_konstante:                                  'Editmarker: Konstante
'
'16. Konstanten
'--------------
A_161_flag:                                       'Editmarker: Flag
'-
A_162_wert:                                       'Editmarker: Wert
'
   Ba_kon = 5                                     'Anzahl der Betriebsarten
   Ld_kon = 1                                     'Tastverhltnis LED: <n>*10%
   Hg_kon = 180                                   'Heizung: <n> s
   Lm_kon = 5                                     'Einschaltdauer: <n>*10%
   Tv_kon = 50                                    'Tastverhltnis SD: <n>%
'
A_163_array:                                      'Editmarker: Array
'-
'
'-------------------------------------------------------------------------------
'
'Lebenszeichen
'-------------
'Neustart
'Er wird durch das Drcken beider Tasten ausgelt.
M_ns:

'Blinken beim Programmstart
'-besseres Verhalten bei deaktivierten Interrupts
Disable Interrupts
   For Hz01 = 1 To 6
      Toggle Led_gn                               'LED_gn (3x)
      Waitms 300
   Next Hz01

   Hs_mor = "o" : Gosub Up_mor                    'Tonausgabe "o" (---)
Enable Interrupts

'Betriebsart
'Sie wird im Eeprom gespeichert; die Anzahl kann bis auf 255 erhht werden.
'Die sptere Ausgabe ber den Morsecode ist entsprechend anzupassen.
   Readeeprom Ba , &H1                            'Adresse: 1
   If Ba > Ba_kon Then                            'Erststart (Eeprom leer)
      Ba = 1
      Writeeeprom Ba , &H1                        'EEprom: Wert [var, adr]
   End If
   Wait 1

'Umschaltung der Betriebsart
'Ist zum aktuellen Zeitpunkt nach dem Start eine Taste gedrckt, wird die Be-
'triebsart auf den nchsten Wert geschaltet und per Morsecode ausgegeben.
'Bleibt die Taste weiter gedrckt, wird die nchste Betriebsart eingestellt.
M_ba:
   If T1 = 0 Or T2 = 0 Then                       'Tastenabfrage
      Incr Ba
      If Ba > Ba_kon Then Ba = 1                  'Betriebsart: 1...<Ba_kon>
      Hs_mor = Str(ba) : Gosub Up_mor             'Tonausgabe
      Wait 3
      Writeeeprom Ba , &H1                        'EEprom: Wert [var, adr]
      Goto M_ba                                   'Tastenabfrage
   End If
'
'-------------------------------------------------------------------------------
'20. === P R O G R A M M =======================================================
'-------------------------------------------------------------------------------
'
A_000_init:                                       'Editmarker: Initialisierung
A_210_init:                                       'Editmarker: Initialisierung
'
'Initialisierung
'---------------
   M_tas = 0                                      'Tastencode
   Reset F_tas                                    'Reset: Flag (nach Neustart)

'Startwert Modus entsprechend der Betriebsart
   M_mod = 10 * Ba
   M_gz = M_mod                                   'Grundzustand fr Betriebszeit

A_000_programm:                                   'Editmarker: Programm
A_220_programm:                                   'Editmarker: Programm
'
Do
'*******************************************************************************
A_000_option:                                     'Editmarker: Programm
A_221_option:                                     'Editmarker: Programm
'
'Option
   Set Fop_f                                      'Ein: Sicherungsberwachung
   Set Fop_l                                      'Ein: Lftermotorsteuerung
   Set Fop_t                                      'Ein: Temperaturberwachung
'*******************************************************************************
'
'berwachung
   Gosub Up_uwf                                   'Sicherung LSK
   Gosub Up_uwt                                   'Temperatur
'Funktionen
   Gosub Up_bz                                    'Betriebszeit
   Gosub Up_tas                                   'Tastenauswertung

'Betriebsart (BA)
'----------------
'BA 1 - Temperatursteuerung fr Ltkolben (0-100% Heizleistung in 10%-Schritten
'BA 2 - Handbetrieb (SD: Ein- und Ausschalten)
'BA 3 - Zyklus Kochen (SD: 0,5h 100%, danach 0,5h 50%)
'BA 4 - %
'BA 5 - %
'-- - - nicht realisiert (Schaltuhr-Zeit)
'-- - - nicht realisiert (Schaltuhr-Zufall)
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'BA   MOD  SD   T   Dauer      SD   Heizleistung
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
' 1    10  Aus  T1  kurz/lang  Ein  100%, automatische Umschaltung in Modus 1
' 1    11  Ein  --  ----/----  Ein  nach 200 s Reduzierung auf 50%
' 1    12  Ein  T1  kurz/----  Ein  Erhhung um 10%
' 1    12  Ein  T1  ----/lang  Ein  Erhhung auf 100%
' 1    12  Ein  T2  kurz/----  Ein  Reduzierung um 10%
' 1    12  Ein  T2  ----/lang  Aus  -
'...............................................................................
' 2    20  Aus  T1  kurz/----  Ein  SD einschalten
' 2    21  Ein  T2  kurz/----  Aus  SD ausschalten
'...............................................................................
' 3    30  Aus  T1  kurz/----  Ein  SD fr 0,5 h einschalten
' 3    31  Ein  --  ----/----  Ein  SD fr 0,5 h mit 50% Heizleistung
'...............................................................................

'Signalisierung bei defekter Sicherung
   If F_tas = 1 And F_uws = 1 Then
      Waitms 200
      Hs_mor = "f" : Gosub Up_mor                 'Tonausgabe "f" (..-.)
   End If

'Tastenauswertung
   Select Case M_tas                              'Tastencode
'Taste 1 - kurz
      Case 10 To 13
         Select Case M_mod
            Case 10
               M_mod = 11
               T_hg = Hg_kon                      'BA1-M10: Aufheizzeit
            Case 12
               If Tv < 100 Then
                  Tv = Tv + 10                    'BA1-M12:Heizung +10%
               End If
            Case 20
               M_mod = 21                         'BA2-M21: SD Ein
            Case 30
               M_mod = 31                         'BA3-M31: SD Ein
               Z_001h = 0                         'Reset Zhler 1h
         End Select
'Taste 1 - lang
      Case 14 To 19
         Select Case M_mod
            Case 10
               M_mod = 11
               T_hg = Hg_kon                      'BA1-M11: Aufheizzeit
            Case 12
               Tv = 100                           'BA1-M12: Heizung: 100%
         End Select
'Taste 2 - kurz
      Case 20 To 23
         Select Case M_mod
            Case 11                               'BA1-M10: Bereitschaft
               M_mod = 10
            Case 12
               If Tv >= 10 Then
                  Tv = Tv - 10                    'BA1-M12: Heizung -10%
               End If
               If Tv = 0 Then
                  M_mod = 10                      'BA1-M10: Bereitschaft
               End If
            Case 21
               M_mod = 20                         'BA2-M20: SD Aus
            Case 31
               M_mod = 30                         'BA3-M30: SD Aus
            End Select
'Taste 2 - lang
      Case 24 To 29
         Select Case M_mod
            Case 11 To 12
               M_mod = 10                         'BA1-M10: Bereitschaft
'            Case 12
'               Tv = 0                            'BA1-M12: Heizung: 0%
         End Select
'Taste 1/2 gemeinsam
      Case 100
         Goto M_ns                                'Neustart
   End Select

'Lschung Tasten-Inhalt
   Reset F_tas                                    'Reset: Flag
   M_tas = 0

M_ende:
'Ende Programmschleife
Loop

'Ende Programm
End

'-------------------------------------------------------------------------------
'30. === I N T E R R U P T R O U T I N E =======================================
'-------------------------------------------------------------------------------
'
A_310_int_t0:                                     'Editmarker: INT T0
'
'Timer 0
'-------
Int_tim0:
'Interrupt: 1 ms
'Voreinstellung des Zhlers
   Timer0 = T0_tve                                'Voreinstellung
'Taktgeber
   Incr Z_010ms                                   'Zhler: Takt ( 10 ms)
   Incr Z_100ms                                   'Zhler: Takt (100 ms)

'Takt:  10 ms
   If Z_010ms = 10 Then
      Z_010ms = 0
   End If
'Takt: 100 ms
   If Z_100ms = 100 Then
      Z_100ms = 0
      Reset Watchdog                              'AVR: Laufzeitberwachung
   End If

'Steuerung LED-Helligkeit
   Select Case Z_010ms
      Case 0                                      'LED Ein
         Led_rt = F_rt
         Led_gn = F_gn
         Led_bl = F_bl
      Case Ld_kon                                 'LED Aus
         Reset Led_rt
         Reset Led_gn
         Reset Led_bl
   End Select

'Lftermotor schalten (PWM)
'--------------------------
' Der Lftermotor luft nur, wenn sich der Modus nicht im jeweiligen Ausgangs-
' zustand M_gz befindet und die Sicherung nicht defekt ist.
   If Fop_l = 1 Then                              'Flag: Option Lftersteuerung
      If M_mod <> M_gz Then
         Select Case Z_010ms
            Case 0
               If F_uws = 0 Then                  'Flag: Sicherung ok
                  Set Lm                          'Lftermotor: Ein
               End If
            Case Lm_kon
               Reset Lm                           'Lftermotor: Aus
         End Select
      Else
         Reset Lm
      End If
   End If

Int0_ret:
Return

A_320_int_t2:                                     'Editmarker: INT T2
'
'Timer 2
Int_tim2:
'Interrupt: 10 ms
'Voreinstellung des Zhlers
   Timer2 = T2_tve                                'Voreinstellung
'Taktgeber
   Incr Z_001s                                    'Zhler Takt   1 s

'Takt: 1 s
   If Z_001s = 100 Then
      Z_001s = 0                                  'Reset Zhler
      Incr Z_030s                                 'Zhler Takt  30 s
'2xINCR: Periode 50s
      Incr Z_100s                                 'Zhler Takt 100 s
      Incr Z_100s                                 'Zhler Takt 100 s
'Takt: 30 s
      If Z_030s = 30 Then                         'Zhler Takt  30 s
         Z_030s = 0                               'Reset Zhler
      End If
'Takt:  50 s
      If Z_100s = 100 Then                        'Zhler Takt 100 s
         Z_100s = 0                               'Reset Zhler
      End If
'Takt: 1 h
' Der Takt fr die Betriebszeit wird nur gezhlt, wenn sich der Modus nicht
' im jeweiligen Ausgangszustand befindet.
      If M_mod <> M_gz Then
         If Z_001h < 4000 Then                    'maximaler Zhlwert: 4000
            Incr Z_001h                           'Zhler Takt   1 h
         End If
         If Z_001h = 3600 Then                    'Betriebszeit (maximal 1h)
            Incr Z_001h                           'weiteres Setzen verhindern
            Set F_bz                              'Set: Flag
         End If
      End If
  End If

'Reduzierung der Restzeit fr das Anheizen
      If T_hg > 0 And Z_001s = 0 Then             'im Sekundentakt
         Decr T_hg                                'Zeit: Heizung 100%
      End If

'Prfung
'-------
'Sicherung LSK
   If F_uws = 1 Then                              'Flag: Sicherung defekt
      Select Case Z_001s
         Case 0
            Set F_bl                              'Set: F_blau
            Reset F_rt : Reset F_gn               'Reset: F_gelb
            Reset Sd                              'SD: Aus
         Case 30                                  'Blitzzeit: 30 ms
            Reset F_bl                            'Reset: F_blau
      End Select
      Goto Int2_ret                               'UP-Ende
    End If

'Temperatur Khlkrper
   If F_uwt = 1 Then                              'Temperatur zu hoch
      Select Case Z_001s
         Case 0
            Set F_rt : Set F_bl                   'Set: F_magenta
            Reset F_gn                            'Reset: F_gelb
            Reset Sd                              'SD: Aus
         Case 30                                  'Blitzzeit: 30 ms
            Reset F_rt : Reset F_bl               'Reset: F_magenta
      End Select
      Goto Int2_ret                               'UP-Ende
    End If

'LED und Steckdose schalten
'--------------------------
' Das Schalten ist vom Modus abhngig; der mgliche Modus von der Betriebsart.
   Select Case M_mod
      Case 10                                     'BA1-M10 SD Aus
         Reset F_bl
         Select Case Z_001s
            Case 0
               Set F_rt : Set F_gn                'Set: F_gelb
               Reset Sd
            Case 1                                'Blitzzeit: 1 ms
               Reset F_rt : Reset F_gn            'Reset: F_gelb
         End Select
      Case 11                                     'BA1-M11 Aufheizen 100%
         Reset F_gn : Reset F_bl                  '~~~~~~~~~~~~~~~~~~~~~~
         Set F_rt                                 'Set: F_rot
         Set Sd                                   'Set: SD
         If T_hg = 0 Then
            M_mod = 12                            'Umschaltung Modus
            Tv = Tv_kon                           'Tastverhltnis 50%
            Z_100s = 0
         End If
      Case 12                                     'BA1-M12 Tastverhltnis
         Reset F_bl                               '~~~~~~~~~~~~~~~~~~~~~~
         Select Case Z_100s
            Case 0
               Set F_gn : Reset F_rt              'Set: F_grn
               Reset Sd                           'Reset: SD
            Case Tv
               Reset F_gn : Set F_rt              'Set: F_rot
               Set Sd                             'Set: SD
         End Select
      Case 20                                     'BA2-M20 SD Aus
         Reset F_bl                               '~~~~~~~~~~~~~~
         Set F_rt : Set F_gn                      'Reset: F_blau, Set: F_gelb
         Reset Sd                                 'Reset: SD
      Case 21                                     'BA2-M21 SD Ein
         Reset F_rt : Reset F_gn                  '~~~~~~~~~~~~~~
         Set F_bl                                 'Reset: F_gelb, Set: F_blau
         Set Sd                                   'Set: SD
      Case 30                                     'BA3-M30 SD Aus
          Reset F_rt                              '~~~~~~~~~~~~~~
          Set F_gn : Set F_bl                     'Reset: F_rot, Set: F_cyan
          Reset Sd                                'Reset: SD
      Case 31                                     'BA3-M31 SD Ein (Kochen)
         If Z_001h < 1800 Then                    '~~~~~~~~~~~~~~~~~~~~~~~
            Reset F_rt : Reset F_gn               '0-0,5h: 100%; Reset: F_gelb
            Set F_bl                              'Set: F_blau
            Set Sd                                'Set: SD
         Else                                     '0,5-1h: 50%
            If Z_100s = 0 Then
               Set F_bl                           'Set: F_blau
               Reset F_rt : Reset F_gn            'Reset: F_gelb
               Set Sd                             'Set: SD
            End If
            If Z_100s = 50 Then
               Reset F_bl                         'Reset: F_blau
               Set F_rt : Set F_gn                'Set: F_gelb
               Reset Sd                           'Reset: SD
            End If
         End If
   End Select

Int2_ret:
Return

'-------------------------------------------------------------------------------
'40. === U N T E R P R O G R A M M =============================================
'-------------------------------------------------------------------------------
'Betriebszeitberwachung
'-----------------------
A_410_upbz:                                       'Editmarker: UP10
'
'Signalisierung 3x alle 50 s, wenn die Betriebszeit von 1 h berschritten ist,
'ohne dass eine Taste bettigt wurde.
'Kurze Zeit spter erfolgt die automatische Abschaltung.
Up_bz:
   If F_bz = 1 And Z_100s = 0 Then
      For Hz01 = 1 To 3
         Set Ton : Waitms 300                     'Signalisierung
         Reset Ton : Waitms 300
      Next Hz01
   End If

   If Z_001h > 3800 Then
      Set Ton : Wait 1 : Reset Ton                'Signalisierung
      Z_001h = 0                                  'Reset: Zhler 1h
      Reset F_bz                                  'Reset: Flag
      M_mod = 10 * Ba                             'Startwert
   End If

Return_bz:
Return

'Abfrage der Tasten
'------------------
A_411_uptas:                                      'Editmarker: UP11
'
'Fr die Eingabe sind zwei Tasten vorhanden.
Up_tas:
   If F_tas = 1 Then                              'Auswertung noch nicht erfolgt
      Goto Return_tas                             'Abbruch der Routine
   Else
'Prfung auf Tastendruck
      If T2 = 1 And T1 = 1 Then                   'keine Taste bettigt
         Goto M_t00
      End If
'> Taste 1
M_T2:
      If T2 = 0 And T1 = 1 Then
         Waitms 20                                'Entprellzeit
         If T2 = 0 And M_tas = 0 Then
            Set Ton : Waitms 5 : Reset Ton        'Tastenklick (5 ms)
            M_tas = 10
         End If
         Waitms 200                               'Zeitmessung
         If M_tas >= 10 And M_tas < 19 Then
            Incr M_tas
         End If
         Goto M_T2
      End If
'> Taste 2
M_T1:
      If T2 = 1 And T1 = 0 Then
         Waitms 20                                'Entprellzeit
         If T1 = 0 And M_tas = 0 Then
            Set Ton : Waitms 5 : Reset Ton        'Tastenklick (5 ms)
            M_tas = 20
         End If
         Waitms 200                               'Zeitmessung
         If M_tas >= 20 And M_tas < 29 Then
            Incr M_tas
         End If
         Goto M_T1
      End If

'> Taste 1/2
      If T2 = 0 And T1 = 0 Then
         Waitms 20                                'Entprellzeit
         If T2 = 0 And T1 = 0 Then
            Waitms 200
            Hs_mor = "s" : Gosub Up_mor           'Tonausgabe "s"
            M_tas = 100                           'Merker fr Neustart
         End If
      End If
M_t12:
      If T2 = 0 And T1 = 0 Then                   'beide Tasten noch gedrckt
         Waitms 500
         Goto M_t12
      End If

      Set F_tas                                   'Befehl zur Auswertung
      Z_001h = 0                                  'Reset: W der Betriebszeit
M_t00:
   End If

Return_tas:
Return

'berwachung der Sicherung (Laststromkreis)
'------------------------------------------
A_412_upuwf:                                      'Editmarker: UP12
'
Up_uwf:
'Die berwachung erfolgt alle 50 s und muss beachten, dass der Optokoppler nur
'in einer Halbwelle (50Hz: T= 20ms) angesteuert wird.
   If Fop_f = 1 And Z_100s = 0 Then               'Fop_F: Option Sicherung
      Set F_uwf                                   'Set: Flag (Sicherung defekt)
      For Hz01 = 1 To 20
         If Uw_f = 0 Then                         'Prfung: ok
            Reset F_uwf                           'Reset: Flag
            Exit For
         End If
         Waitms Hz01
      Next Hz01
'Wenn eine defekte Sicherung erkannt wird, wird der Modus in den Grundzustand
'geschaltet.
'Die Signalisierung erfolgt dann durch eine blitzende LED (Farbe: blau).
      If F_uwf = 1 Then
         M_mod = M_gz
         Set F_uws
      Else
         Reset F_uws
      End If
   End If

Return_uwf:
Return

'berwachung der Temperatur (Khlkrper)
'---------------------------------------
A_413_upuwt:                                      'Editmarker: UP13
'
Up_uwt:
'Die berwachung erfolgt alle 100s.
'
'Schaltertyp
'~~~~~~~~~~~
'Die Auswertung bezieht sich auf einen NC-Schalter (nc: normal geschlossen).
'Wird ein NO-Schalter (no: normal offen) eingesetzt, ist das Signal zu negieren.
'Bei einer analogen Temperaturberwachung mit Hei- oder Kaltleiterwiderstnden
'ist dies mit dem ADC zu realisieren.

   If Z_100s = 0 And Fop_t = 1 Then               'Fop_T: Option Temperatur
      F_uwt = Not Uw_t                            'Set: Flag (no: Temp. zu hoch)
'Wenn eine zu hohe Temperatur erkannt wird, wird der Modus in den Grundzustand
'geschaltet.
'Die Signalisierung erfolgt dann durch eine blitzende LED (Farbe: magenta).
      If F_uwt = 1 Then
         M_mod = M_gz                             'Modus: Grundzustand
      End If
   End If

Return_uwt:
Return

'Tonausgabe
'----------
A_414_upmor:                                      'Editmarker: UP13
'
Up_mor:
'Wandlung in ASCII
   Hs_mor = Ucase(hs_mor)                         'Zeichen gro
   Hm_mc = Asc(hs_mor)

   Select Case Hm_mc
      Case 0                                      'Pause 100 ms
         Waitms 100
         Goto Upmor_ret                           'Return
'Ziffer
      Case 48                                     '0
         Hs_mor = "-----"
      Case 49                                     '1
         Hs_mor = ".----"
      Case 50                                     '2
         Hs_mor = "..---"
      Case 51                                     '3
         Hs_mor = "...--"
      Case 52                                     '4
         Hs_mor = "....-"
      Case 53                                     '5
         Hs_mor = "....."
      Case 54                                     '6
         Hs_mor = "-...."
      Case 55                                     '7
         Hs_mor = "--..."
      Case 56                                     '8
         Hs_mor = "---.."
      Case 57                                     '9
         Hs_mor = "----."
'Buchstabe
      Case 65                                     'A
         Hs_mor = ".-"
      Case 66                                     'B
         Hs_mor = "-..."
      Case 67                                     'C
         Hs_mor = "-.-."
      Case 68                                     'D
         Hs_mor = "-.."
      Case 69                                     'E
         Hs_mor = "."
      Case 70                                     'F
         Hs_mor = "..-."
      Case 71                                     'G
         Hs_mor = "--."
      Case 72                                     'H
         Hs_mor = "...."
      Case 73                                     'I
         Hs_mor = ".."
      Case 74                                     'J
         Hs_mor = ".---"
      Case 75                                     'K
         Hs_mor = "-.-"
      Case 76                                     'L
        Hs_mor = ".-.."
      Case 77                                     'M
         Hs_mor = "--"
      Case 78                                     'N
         Hs_mor = ".-"
      Case 79                                     'O
         Hs_mor = "---"
      Case 80                                     'P
         Hs_mor = ".--."
      Case 81                                     'Q
         Hs_mor = "--.-"
      Case 82                                     'R
         Hs_mor = ".-."
      Case 83                                     'S
         Hs_mor = "..."
      Case 84                                     'T
         Hs_mor = "-"
      Case 85                                     'U
         Hs_mor = "..-"
      Case 86                                     'V
         Hs_mor = "...-"
      Case 87                                     'W
         Hs_mor = ".--"
      Case 88                                     'X
         Hs_mor = "-..-"
      Case 89                                     'Y
         Hs_mor = "-.--"
      Case 90                                     'Z
         Hs_mor = "--.."
   End Select

   For Hz_mz = 1 To Len(hs_mor)
      Hs01 = Mid(hs_mor , Hz_mz , 1)

      If Hs01 = "." Then
         Set Ton : Waitms 70
      Else
         Set Ton : Waitms 210
      End If

      Reset Ton
      Waitms 70
   Next Hz_mz

Upmor_ret:
Return

'-------------------------------------------------------------------------------
'50. === U N T E R P R O G R A M M - C A L L ===================================

'-------------------------------------------------------------------------------

'-------------------------------------------------------------------------------
'60. === I N I T I A L I S I E R U N G   D E R   S L A V E S ===================
'-------------------------------------------------------------------------------

'-------------------------------------------------------------------------------
'70. === F U N K T I O N =======================================================
'-------------------------------------------------------------------------------

'-------------------------------------------------------------------------------
'80. === D A T E N B E R E I C H ===============================================
'-------------------------------------------------------------------------------
'
'Ende Datenbereich

'###############################################################################

'Ende
